import os, glob, hashlib, numpy as np, pandas as pd
from pathlib import Path

def e0_hash(path):
    a = np.load(path, allow_pickle=False)["E0"]
    return hashlib.sha256(a.tobytes()).hexdigest(), float(a.std())

rows=[]
for p in glob.glob(r"data/inputs/**/E0.npz", recursive=True):
    parts = Path(p).parts
    # .../inputs/<gauge>/L256/b3.5/k1.00/f0.00/seed0/E0.npz
    gauge = parts[-7]; L = int(parts[-6][1:]); b = float(parts[-5][1:])
    kappa = float(parts[-4][1:]); f = float(parts[-3][1:]); seed = int(parts[-2][4:])
    h, s = e0_hash(p)
    rows.append(dict(gauge=gauge,L=L,b=b,kappa=kappa,f=f,seed=seed,e0_hash=h,e0_std=s, path=p))

df = pd.DataFrame(rows).sort_values(["gauge","L","b","kappa","f","seed"])
print("unique E0 hashes per (gauge,L,b,kappa):")
print(df.groupby(["gauge","L","b","kappa"])["e0_hash"].nunique())
print("\nany flat files? (std≈0)")
print(df[df["e0_std"]<1e-12][["path","e0_std"]])
df.to_csv("results_cc/e0_hashes.csv", index=False)
print("\nwrote results_cc/e0_hashes.csv")
